import csv

def load_animal_data(file_name='animals.csv'):
    reader = csv.DictReader(open(file_name, 'r', encoding='utf-8-sig'))
    headers = reader.fieldnames
    questions = headers[2:]
    animal_pmf = {}
    question_data = {}
    for question in questions:
        question_data[question] = {}
    for row in reader:
        animal = row['Animal']
        probability = float(row['Probability'])
        animal_pmf[animal] = probability
        for question in questions:
            answer_raw = row[question]
            
            answer = True if answer_raw == 'yes' else False
            question_data[question][animal] = answer

    # next we add in a question: "Is it a {animal}?"
    for animal in animal_pmf:
        question_data[f"Is it a {animal}?"] = {animal: True}
        for other in animal_pmf:
            if other != animal:
                question_data[f"Is it a {animal}?"][other] = False

    return animal_pmf, question_data